jQuery(function($){

	$.fn.fmatter.modoRecepcion = function(cellval,opts, rwd) {	
		var str = "";
		if (rwd.t03ModoRecepcion == "0"){
			str = "<div align='center'>ZIP</span></div>";
		}else{
			str = "<div align='center'>XML</span></div>";
		}
		return str;
	};
	
	$("#botonLimpiarCriterios").click(function(){
		fncLimpiarCampos("#divCriteriosBusqueda");
		fncBuscar();
	});
	
	$('#modoRecepcion').rup_combo({
		source : [
			{i18nCaption: "xml", value:"1" },
			{i18nCaption: "zip", value:"0" }
			],
		orderedByValue:true,
	width: "200px",
	menuWidth: "200px",
	selected: 0	
	});
	
	//definición del acordeón de los criterios de búsqueda
	$("#divCriteriosBusqueda").rup_accordion({
		collapsible: true
	});
	
	//popup de edición de eventos del calendario
	$( "#divEditarRegistro" ).rup_dialog({
		autoOpen: false,
	//	height: 300,
		width: 500,
		modal: true,
		resizable: false,
		position: "center",
		type: $.rup.dialog.DIV
	});

	//Añadimos las funciones a los botones 
	$("#botonBuscar").click(fncBuscar);
	//al pulsar intro, que busque
	$("#FORMULARIO").keypress(function(event){
		if (event.which == 13){
			fncBuscar();
		}
	});
	
	$("#botonModificarRegistro").click(modificarRegistro);
	$("#botonAltaRegistro").click(altaRegistro);
	$("#botonGuardarRegistro").click(guardarRegistro);
	$("#botonSalirRegistro").click(cerrarDetalleRegistro);
	
	/* DATA GRID */
	$("#GRID_mantenimiento").rup_grid({
		
		url: "../aplicacion/mantenimiento/tabla",
		colNames: [
			$.rup.i18n.app.GRID_mantenimiento.id,
		    $.rup.i18n.app.GRID_mantenimiento.descEs,
		    $.rup.i18n.app.GRID_mantenimiento.descEu,
		    $.rup.i18n.app.GRID_mantenimiento.modoRecepcion
		],
		colModel: [
			{ 	name: "t03IdAplicacion", 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "t03DescEs", 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "t03DescEu", 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "t03ModoRecepcion", 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				formatter: "modoRecepcion"
			}
        ],
		sortorder: "asc",
		loadOnStartUp: true
	});
	
	/* FORMULARIO */
	$("#FORMULARIO_MANTENIMIENTO").rup_form({
		url:$.rup.CTX_PATH+"aplicacion",
		feedback:$("#feedbackMensajesMantenimiento"),
		type: "POST",
		dataType: "json",
		success:function(xhr){
			$("#feedbackMensajesMantenimiento").rup_feedback("set", $.rup.i18n.app.mensajes.ok.datos_guardados_ok, "ok");
			
			var filaArray = $.rup_utils.jsontoarray(xhr);
			$.rup_utils.populateForm(filaArray, $("#FORMULARIO_MANTENIMIENTO"));
			
			fncResetearCambios();
			
			//Recargamos la tabla haciendo la petición al servidor
			$("#GRID_mantenimiento").rup_grid("reloadGrid");
		},
		error: function (xhr, ajaxOptions, thrownError) {
			$("#feedbackMensajesMantenimiento").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_guardados_error, "error");
		},
		validate:{
			rules:{
				"t03DescEs":{required:true},
				"t03DescEu":{required:true},
				"t03ModoRecepcion":{required:true}
			}
		}
	});	
	
	fncAplicarGestionCambios("FORMULARIO_MANTENIMIENTO");
	
	//Creamos el área de mensajes dentro del detalle
	$("#feedbackMensajesMantenimiento").rup_feedback({
		type: "ok",
		closeLink: true,
		block: false
	});	
});

function modificarRegistro(){
	//Obtenemos el número de fila seleccionada
	var numFila = $("#GRID_mantenimiento").rup_grid("getGridParam", "selrow");
	if(numFila && numFila>0){
		//Obtenemos los datos de la fila seleccionada
		var filaMantenimiento = $("#GRID_mantenimiento").rup_grid("getRowData",numFila);
		if (filaMantenimiento.t03ModoRecepcion == 'ZIP') {
			filaMantenimiento.t03ModoRecepcion = 0;
		} else {
			filaMantenimiento.t03ModoRecepcion = 1;
		}
		//Limpiamos el formulario
		//$("#FORMULARIO_MANTENIMIENTO").rup_form("clearForm");
		var filaMantenimientoArray = $.rup_utils.jsontoarray(filaMantenimiento);
		$.rup_utils.populateForm(filaMantenimientoArray, $("#FORMULARIO_MANTENIMIENTO"));
		$("#t03IdAplicacion").prop("disabled", true);
		$("#idAplicacion").show();
		abrirDetalleRegistro();
	}
	else{
		$("#feedbackMensajesMantenimiento").rup_feedback("set", $.rup.i18n.app.mensajes.alert.debe_seleccionar_registro, "alert");
	}
}

/**
 * Función que se llama para mostrar el 
 */
function altaRegistro(){
	//Limpiamos el formulario
	$("#FORMULARIO_MANTENIMIENTO").rup_form("clearForm");
	$("#idRegistro").attr("value","");
	$("#idAplicacion").hide();
	abrirDetalleRegistro();
}

/**
 * Función que llama al controlador para guardar el registro
 */
function guardarRegistro(){
	$("#FORMULARIO_MANTENIMIENTO").submit();
	$( "#divEditarRegistro" ).rup_dialog( "close" );
}

/**
 * Abrir el detalle del registro
 */
function abrirDetalleRegistro(){
	//Eliminamos el dialogo por si tiene iconos de validación de visitas anteriores o mensajes
	fncOcultarValidaciones("#feedbackMensajesDetalle");

	$( "#divEditarRegistro" ).rup_dialog( "open" );
}
 
function cerrarDetalleRegistro()
{
	if (fncComprobarSiCambios()){
		fncConfirmarCambios("$( '#divEditarRegistro' ).rup_dialog( 'close' );");
	}else{
		$( "#divEditarRegistro" ).rup_dialog( "close" );
	}
}

/**
 * Función de búsqueda que recarga la tabla y envía los filtros al controller con una
 * petición ajax 
 */
function fncBuscar(){
	varDescripcionEs = $("#descripcionEs").attr("value");
	varDescripcionEu = $("#descripcionEu").attr("value");
	varModoRecepcion = $("#modoRecepcion").attr("value");
	//Construimos el objeto con los parámetros del filtro a enviar

	var filtro = {
			t03DescEs: varDescripcionEs,
			t03DescEu: varDescripcionEu,
			t03ModoRecepcion: varModoRecepcion
	};

	//Le pasamos al objeto tabla el filtro
	$("#GRID_mantenimiento").rup_grid("setGridParam",{postData: filtro});
	//Recargamos la tabla haciendo la petición al servidor
	$("#GRID_mantenimiento").rup_grid("reloadGrid");
	
	fncOcultarValidaciones("#feedbackMensajesMantenimiento");
	$("#first_pager").click();
}